import scala.collection.parallel.CollectionConverters._

import timer._

object ParExample {
  def main(args: Array[String]): Unit = {
    val n = 100000000
    val v = (1 to n).toVector // A normal, sequential vector of numbers

    // Pick out divisible by 3, but not 5
    val (x, wallX) =  measureWallClockTime(v.filter( i => (i % 3 == 0) && (i % 5 != 0)))

    // Same operation but in parallel, note the '.par'
    val (y, wallY) =  measureWallClockTime(v.par.filter(i => (i % 3 == 0) && (i % 5 != 0)))

    println(s"Sequential time - wall: ${wallX} s.")
    println(s"Par time        - wall: ${wallY} s.")
  }
}
