package matrices:

  import scala.collection.mutable.ArrayBuffer
  import timer._ // Source code can be found in include/timer
  import plotter._ // Source code can be found in include/plotter
  import org.jfree.chart.ChartFrame
  import javax.swing.WindowConstants

 

  import scala.util.Random
  val prng = new Random(2105)

  // Helper to create a random matrix of size n
  def randMatrix(n: Int) =
    val m = new Matrix(n)
    for r <- 0 until n; c <- 0 until n do m(r, c) = prng.nextDouble()
    m
  end randMatrix

 /**
  * Plot run times of matrix addition and multiplication on some random matrices
 */
  @main def main(): Unit =
    val resultsAdd = ArrayBuffer[Tuple2[Double, Double]]()
    val resultsMult = ArrayBuffer[Tuple2[Double, Double]]()
    for n <- 100 to 1000 by 100 do
      Console.println("Measuring with n = " + n)
      val a = randMatrix(n)
      val b = randMatrix(n)
      val (r1, t1) = measureCpuTimeRepeated {
        val c = a + b
        }
    
      resultsAdd += ((n, t1))
      Console.println("  Addition took " + t1 + " seconds")
      val (r2, t2) = measureCpuTimeRepeated {
        val c = a * b
        }

      resultsMult += ((n, t2))
      Console.println("  Multiplication took " + t2 + " seconds")
    end for

    val dsAdd = new DataSet("addition", resultsAdd.toArray)
    val dsMult = new DataSet("multiplication", resultsMult.toArray)

    val p = new Plotter()

    p.xLogScale = false
    p.yLogScale = false

    val chart = p.plot("n", "run time (seconds)", dsAdd, dsMult)
    chart.setTextAntiAlias(true)
    val frame = new ChartFrame(
      "Plot",
      chart
    )
    frame.pack()
    frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE)
    frame.setAlwaysOnTop(true)
    frame.setVisible(true)
  end main

  
